package edu.uky.ai.lp.ai;

import edu.uky.ai.lp.logic.Conjunction;
import edu.uky.ai.lp.logic.Constant;
import edu.uky.ai.lp.logic.Disjunction;
import edu.uky.ai.lp.logic.Fact;
import edu.uky.ai.lp.logic.KnowledgeBase;
import edu.uky.ai.lp.logic.Negation;
import edu.uky.ai.lp.logic.Rule;
import edu.uky.ai.lp.logic.Variable;

/**
 * A utility class for providing the initial Wumpus World knowledge base.
 * 
 * @author Stephen G. Ware
 */
public class WumpusWorld {

	/**
	 * Returns a knowledge base that represents what is known about the Wumpus
	 * World at the start of the game.
	 * 
	 * @return the knowledge base
	 */
	public static final KnowledgeBase getKnowledgeBase() {
		return new KnowledgeBase(
				new Rule[] {
					new Rule(
						new Conjunction(
							new Fact("adjacent", new Variable("A"), new Variable("B")),
							new Fact("visited", new Variable("B")),
							new Negation(new Fact("breeze", new Variable("B")))
						),
						new Fact("noPit", new Variable("A"))
					),
					new Rule(
						new Conjunction(
							new Fact("adjacent", new Variable("C"), new Variable("D")),
							new Fact("visited", new Variable("D")),
							new Negation(
								new Fact("stench", new Variable("D"))
							)
						),
						new Fact("noWumpus", new Variable("C"))
					),
					new Rule(
						new Disjunction(
							new Fact("visited", new Variable("E")),
							new Conjunction(
								new Fact("noPit", new Variable("E")),
								new Fact("noWumpus", new Variable("E"))
							)
						),
						new Fact("safe", new Variable("E"))
					),
					new Rule(
						new Conjunction(
							new Fact("safe", new Variable("F")),
							new Negation(
								new Fact("visited", new Variable("F"))
							)
						),
						new Fact("hint", new Variable("F"))
					)
				},
				new Fact[] {
					new Fact("adjacent", new Constant("a1"), new Constant("a2")),
					new Fact("adjacent", new Constant("a2"), new Constant("a1")),
					new Fact("adjacent", new Constant("a1"), new Constant("b1")),
					new Fact("adjacent", new Constant("b1"), new Constant("a1")),
					new Fact("adjacent", new Constant("a2"), new Constant("a3")),
					new Fact("adjacent", new Constant("a3"), new Constant("a2")),
					new Fact("adjacent", new Constant("a2"), new Constant("b2")),
					new Fact("adjacent", new Constant("b2"), new Constant("a2")),
					new Fact("adjacent", new Constant("a3"), new Constant("a4")),
					new Fact("adjacent", new Constant("a4"), new Constant("a3")),
					new Fact("adjacent", new Constant("a3"), new Constant("b3")),
					new Fact("adjacent", new Constant("b3"), new Constant("a3")),
					new Fact("adjacent", new Constant("a4"), new Constant("b4")),
					new Fact("adjacent", new Constant("b4"), new Constant("a4")),
					new Fact("adjacent", new Constant("b1"), new Constant("b2")),
					new Fact("adjacent", new Constant("b2"), new Constant("b1")),
					new Fact("adjacent", new Constant("b1"), new Constant("c1")),
					new Fact("adjacent", new Constant("c1"), new Constant("b1")),
					new Fact("adjacent", new Constant("b2"), new Constant("b3")),
					new Fact("adjacent", new Constant("b3"), new Constant("b2")),
					new Fact("adjacent", new Constant("b2"), new Constant("c2")),
					new Fact("adjacent", new Constant("c2"), new Constant("b2")),
					new Fact("adjacent", new Constant("b3"), new Constant("b4")),
					new Fact("adjacent", new Constant("b4"), new Constant("b3")),
					new Fact("adjacent", new Constant("b3"), new Constant("c3")),
					new Fact("adjacent", new Constant("c3"), new Constant("b3")),
					new Fact("adjacent", new Constant("b4"), new Constant("c4")),
					new Fact("adjacent", new Constant("c4"), new Constant("b4")),
					new Fact("adjacent", new Constant("c1"), new Constant("c2")),
					new Fact("adjacent", new Constant("c2"), new Constant("c1")),
					new Fact("adjacent", new Constant("c1"), new Constant("d1")),
					new Fact("adjacent", new Constant("d1"), new Constant("c1")),
					new Fact("adjacent", new Constant("c2"), new Constant("c3")),
					new Fact("adjacent", new Constant("c3"), new Constant("c2")),
					new Fact("adjacent", new Constant("c2"), new Constant("d2")),
					new Fact("adjacent", new Constant("d2"), new Constant("c2")),
					new Fact("adjacent", new Constant("c3"), new Constant("c4")),
					new Fact("adjacent", new Constant("c4"), new Constant("c3")),
					new Fact("adjacent", new Constant("c3"), new Constant("d3")),
					new Fact("adjacent", new Constant("d3"), new Constant("c3")),
					new Fact("adjacent", new Constant("c4"), new Constant("d4")),
					new Fact("adjacent", new Constant("d4"), new Constant("c4")),
					new Fact("adjacent", new Constant("d1"), new Constant("d2")),
					new Fact("adjacent", new Constant("d2"), new Constant("d1")),
					new Fact("adjacent", new Constant("d2"), new Constant("d3")),
					new Fact("adjacent", new Constant("d3"), new Constant("d2")),
					new Fact("adjacent", new Constant("d3"), new Constant("d4")),
					new Fact("adjacent", new Constant("d4"), new Constant("d3")),
					new Fact("visited", new Constant("a1"))
				}
			);
	}
}
